﻿using Helper;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using ZSMusic.BLL;
using ZSMusic.Model;

namespace WEB
{
    public partial class getdata : System.Web.UI.Page
    {//getdata.aspx?source=qq&id=000B4ijs4Ufwql&name=微微&artist=傅如乔&album=微微&albumid=003Lr7ct0vUSj3&type=all&redirect=0
        protected void Page_Load(object sender, EventArgs e)
        {
            Music m = new Music();
            string result = "";
            try
            {
                m.Source = Request["source"];
                m.Id = Request["id"];
                m.Name = Request["name"];
                m.Artist = Request["artist"];
                m.Album = Request["album"];
                m.AlbumId = Request["albumid"];
                MusicHelper.GetData(m, Request["type"]);
                switch (Request["type"])
                {
                    case "all":
                    case "url":
                        if (!HttpHelper.CheckUri(m.Url))
                        { m = MusicHelper.ReSearch(m, 0.9, Request["type"]); }
                        break;
                    case "pic":
                        if (!HttpHelper.CheckUri(m.PicUrl))
                        { m = MusicHelper.ReSearch(m, 0.9, Request["type"]); }
                        break;
                    case "lrc":
                        if (string.IsNullOrWhiteSpace(m.Lrc))
                        { m = MusicHelper.ReSearch(m, 0.9, Request["type"]); }
                        break;
                    default:
                        throw new Exception("参数错误 参数名:type");
                }

                if (Request["redirect"] == "1")
                {
                    switch (Request["type"])
                    {
                        case "all":
                        case "url":
                            Response.Redirect(m.Url);
                            break;
                        case "pic":
                            Response.Redirect(m.PicUrl);
                            break;
                        case "lrc":
                            result = m.Lrc;
                            break;
                        default:
                            throw new Exception("参数错误 参数名:type");
                    }
                }
                else
                {
                    result = JsonConvert.SerializeObject(m);
                }


            }
            catch (Exception ex)
            {
                result = JsonConvert.SerializeObject(ex);
            }
            Response.Write(result);
        }
    }
}